<form id="bookingForm">
  <label>Name</label>
  <input type="text" name="name" required>

  <label>Email</label>
  <input type="email" name="email" required>

  <label>Date</label>
  <input type="date" name="date" id="date" required>

  <label>Time</label>
  <select name="time" id="time" required>
    <option value="">Select time</option>
  </select>

  <button type="submit">Book Appointment</button>
</form>

<div id="result"></div>

<script>
const timeSelect = document.getElementById("time");
const dateInput = document.getElementById("date");

// Generate times from 6am–6pm
function generateTimes(bookedTimes = []) {
  timeSelect.innerHTML = '<option value="">Select time</option>';
  for (let h = 6; h < 18; h++) {
    ["00", "30"].forEach(m => {
      let t = `${String(h).padStart(2, "0")}:${m}`;
      if (!bookedTimes.includes(t)) {
        timeSelect.innerHTML += `<option value="${t}">${t}</option>`;
      }
    });
  }
}

dateInput.addEventListener("change", () => {
  fetch(`get_booked_times.php?date=${dateInput.value}`)
    .then(res => res.json())
    .then(data => generateTimes(data));
});

document.getElementById("bookingForm").addEventListener("submit", e => {
  e.preventDefault();
  fetch("submit_booking.php", {
    method: "POST",
    body: new FormData(e.target)
  })
  .then(res => res.text())
  .then(msg => document.getElementById("result").innerHTML = msg);
});
</script>