<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <title>Vaughn Consulting-Contact us</title>
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta content="" name="keywords">
        <meta content="" name="description">

        <!-- Google Web Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet"> 

        <!-- Icon Font Stylesheet -->
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"/>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

        <!-- Libraries Stylesheet -->
        <link href="lib/animate/animate.min.css" rel="stylesheet">
        <link href="lib/lightbox/css/lightbox.min.css" rel="stylesheet">
        <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
        <link rel="icon" type="image/png" href="img/vclogo.png">


        <!-- Customized Bootstrap Stylesheet -->
        <link href="css/bootstrap.min.css" rel="stylesheet">

        <!-- Template Stylesheet -->
        <link href="css/style.css" rel="stylesheet">
    </head>

    <body>

        <!-- Topbar Start -->
        <?php include "includes/topbar.php"  ?>
        <!-- Topbar End -->

        <!-- Navbar & Hero Start -->
        <?php include "includes/nav.php"  ?>

            <!-- Header Start -->
            <div class="container-fluid bg-breadcrumb">
                <div class="container text-center py-5" style="max-width: 900px;">
                    <h4 class="text-white display-4 mb-4 wow fadeInDown" data-wow-delay="0.1s">Contact Us</h4>
                    <ol class="breadcrumb d-flex justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active text-primary">Contact</li>
                    </ol>    
                </div>
            </div>
            <!-- Header End -->
        </div>
        <!-- Navbar & Hero End -->

        <!-- Contact Start -->
        <div class="container-fluid contact py-5">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-xl-6">
                        <div class="wow fadeInUp" data-wow-delay="0.2s">
                            <div class="bg-light p-5 rounded h-100">
                                <h4 class="text-primary">Send Your Message</h4>
                                <h4 class="lh-base mb-4">We are ready to answer any questions you may have.</h4>
                                    <form id="contactForm" action="send-mail.php" method="post">
                                        <div class="row g-4">
                                            <div class="col-lg-12 col-xl-6">
                                                <div class="form-floating">
                                                    <input type="text" class="form-control border-0" name="name" id="name" placeholder="Your Name" required>
                                                    <label for="name">Your Name</label>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 col-xl-6">
                                                <div class="form-floating">
                                                    <input type="email" class="form-control border-0" name="email" id="email" placeholder="Your Email" required>
                                                    <label for="email">Your Email</label>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 col-xl-6">
                                                <div class="form-floating">
                                                    <input type="text" class="form-control border-0" name="phone" id="phone" placeholder="Phone">
                                                    <label for="phone">Your Phone</label>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 col-xl-6">
                                                <div class="form-floating">
                                                    <input type="text" class="form-control border-0" name="project" id="project" placeholder="Project">
                                                    <label for="project">Your Project</label>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-floating">
                                                    <input type="text" class="form-control border-0" name="subject" id="subject" placeholder="Subject" required>
                                                    <label for="subject">Subject</label>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-floating">
                                                    <textarea class="form-control border-0" name="message" id="message" style="height: 160px" required></textarea>
                                                    <label for="message">Message</label>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary w-100 py-3" type="submit">Send Message</button>
                                            </div>

                                            <!-- Response Message -->
                                            <div class="col-12">
                                                <div id="formResponse"></div>
                                            </div>
                                        </div>
                                    </form>
                            </div>
                        </div>
                    </div>
                    
                        <div class="col-xl-6 wow fadeInRight" data-wow-delay="0.2s">
                            <div class="rounded h-100">
                                <img src="img/contact.jpg" 
                                    class="rounded h-100 w-100" 
                                    style="height: 400px; object-fit: cover;" 
                                    alt="Contact Image">
                            </div>
                        </div>
                </div>
            </div>
        </div>
        <!-- Contact End -->

        <!-- Footer Start -->
        <?php include "includes/footer.php"  ?>

        <script>
document.getElementById("contactForm").addEventListener("submit", function(e) {
    e.preventDefault();

    const form = this;
    const responseDiv = document.getElementById("formResponse");
    const formData = new FormData(form);

    fetch(form.action, {
        method: "POST",
        body: formData
    })
    .then(res => res.text())
    .then(data => {
        if (data.trim() === "success") {
            responseDiv.innerHTML = `
                <div class="alert alert-success mt-3">
                    ✅ Thank you! Your message has been sent successfully.
                </div>`;
            form.reset();
        } else {
            responseDiv.innerHTML = `
                <div class="alert alert-danger mt-3">
                    ❌ Something went wrong. Please try again later.
                </div>`;
        }
    })
    .catch(() => {
        responseDiv.innerHTML = `
            <div class="alert alert-danger mt-3">
                ❌ Unable to send message. Please check your connection.
            </div>`;
    });
});
</script>

    </body>

</html>