<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <title>Vaughn Consulting-Business Support Services</title>
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta content="" name="keywords">
        <meta content="" name="description">

        <!-- Google Web Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet"> 

        <!-- Icon Font Stylesheet -->
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"/>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

        <!-- Libraries Stylesheet -->
        <link href="lib/animate/animate.min.css" rel="stylesheet">
        <link href="lib/lightbox/css/lightbox.min.css" rel="stylesheet">
        <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
        <link rel="icon" type="image/png" href="img/vclogo.png">


        <!-- Customized Bootstrap Stylesheet -->
        <link href="css/bootstrap.min.css" rel="stylesheet">

        <!-- Template Stylesheet -->
        <link href="css/style.css" rel="stylesheet">
    </head>

    <body>

        <!-- Topbar Start -->
        <?php include "includes/topbar.php"  ?>
        <!-- Topbar End -->

        <!-- Navbar & Hero Start -->
        <?php include "includes/nav.php"  ?>


            <!-- Header Start -->
            <div class="container-fluid bg-breadcrumb">
                <div class="container text-center py-5" style="max-width: 900px;">
                    <h4 class="text-white display-4 mb-4 wow fadeInDown" data-wow-delay="0.1s">Business Support</h4>
                    <ol class="breadcrumb d-flex justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active text-primary">Service</li>
                    </ol>    
                </div>
            </div>
            <!-- Header End -->
        </div>
        <!-- Navbar & Hero End -->


        <!-- Services Start -->
        <div class="container-fluid service py-5">
            <div class="container py-5">
                <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
                    <h4 class="text-primary">Business Support</h4>
                    <h1 class="display-5 mb-4">Expert Business Support for Social Care Providers</h1>
                    <p class="mb-0">Running a social care service isn’t just about managing a business—it’s about providing quality, compassionate care every day. That’s why we offer tailored business support services designed specifically for care homes, domiciliary care agencies, and supported living providers. Whether you’re starting up, expanding, or improving the quality of your service, we’re here to help you stay compliant, sustainable, and focused on what matters most: delivering outstanding care.
                    </p>
                </div>
                <div class="row g-4">
            <div class="col-lg-8 mx-auto wow fadeInUp" data-wow-delay="0.2s">
    
             <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
                    <h4 class="text-primary">How We Can Help</h4>
                </div>
                                <div class="highlights-accordion accordion" id="highlightsAccordion">

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightOne">
                                                Regulatory Compliance & CQC Readiness
                                            </button>
                                        </h2>
                                        <div id="highlightOne" class="accordion-collapse collapse show" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                Ensure you’re always inspection-ready. We support you with policy development, audits, mock inspections, and action plans.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightTwo">
                                                Business Planning & Strategy
                                            </button>
                                        </h2>
                                        <div id="highlightTwo" class="accordion-collapse collapse" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                Set a clear direction for growth. We develop strategic business plans, define objectives, and streamline operations for long-term sustainability.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightThree">
                                                Financial Management & Funding
                                            </button>
                                        </h2>
                                        <div id="highlightThree" class="accordion-collapse collapse" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                From budgeting to cost control, we help manage finances and support funding applications, tenders, and contract management.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightFour">
                                                Recruitment & Workforce Development
                                            </button>
                                        </h2>
                                        <div id="highlightFour" class="accordion-collapse collapse" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                Advice on recruitment strategies, staff retention planning, training solutions, and building a positive workplace culture.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightFive">
                                                Digital Transformation
                                            </button>
                                        </h2>
                                        <div id="highlightFive" class="accordion-collapse collapse" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                Implement digital care planning, compliance tools, and communication systems to improve service delivery.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordion-item highlight-accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed highlight-accordion-btn" type="button" data-bs-toggle="collapse" data-bs-target="#highlightSix">
                                                Care Quality Improvement
                                            </button>
                                        </h2>
                                        <div id="highlightSix" class="accordion-collapse collapse" data-bs-parent="#highlightsAccordion">
                                            <div class="accordion-body highlight-accordion-body">
                                                Tailored improvement plans and service reviews to help achieve or maintain ‘Good’ or ‘Outstanding’ ratings.
                                            </div>
                                        </div>
                                    </div>

                            </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- Services End -->
        
         <div class="container-fluid about py-5">
            <div class="container py-5">
                <div class="row g-5 align-items-center">
                    <div class="col-xl-7 wow fadeInLeft" data-wow-delay="0.2s">
                        <div>
                            <h1 class="display-5 mb-4">It's more than business.<br>It's about care.</h1>
                            <p class="mb-4">We understand the pressures and responsibilities that come with running a care service. It’s not just about managing budgets or staffing—it’s about safeguarding vulnerable people, navigating ever-changing regulations, and delivering consistently high-quality care under intense scrutiny.</p>
                            <p>At the same time, you’re expected to lead a team, maintain morale, keep your service financially viable, and prepare for the next CQC inspection—all while keeping the people you support at the heart of everything you do.</p>
                            <p>That’s why our approach to business support goes beyond spreadsheets and strategy. We become your trusted partner—someone who understands the emotional weight of leadership in the care sector and can provide practical, compassionate guidance when you need it most.</p>
                        </div>
                    </div>
                    <div class="col-xl-5 wow fadeInRight" data-wow-delay="0.2s">
                        <div class="bg-primary rounded position-relative overflow-hidden">
                            <img src="img/care.jpg" class="img-fluid rounded w-100" alt="">
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        
        <!-- Services Start -->
        <div class="container-fluid service py-5">   
                                <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
                                            <h4 class="text-primary">Business Support</h4>
                                            <h1 class="display-5 mb-4">Experience it Yourself</h1>
                                            <p class="mb-0">We’re a team of care-sector specialists with real-world experience in both health and social care and business consultancy. We know the challenges providers face—tight budgets, staffing shortages, and constantly shifting expectations. We’ve been there, and now we’re here to help others navigate it.</p>
                                </div>
                                <div class="business-support">
                                    
                                    <div class="support-text">
                                        <img src="img/carousel-1.jpg" alt="City Image">
                                    </div>
                                    <div class="support-box">
                                        <h3>Who We Support:</h3>
                                        <ul>
                                            <li>Residential & nursing care homes</li>
                                            <li>Domiciliary/home care agencies</li>
                                            <li>Supported living providers</li>
                                            <li>Learning disability & mental health services</li>
                                            <li>Startups entering the care sector</li>
                                        </ul>
                                    </div>
                                </div>            
        </div>
        <!-- Services End -->

        <!-- call-action start -->
         <?php include "includes/call-action.php"  ?>
        <!-- call-action end -->
        
        <!-- Footer Start -->
        <?php include "includes/footer.php"  ?>
    </body>

</html>