<?php
// CONFIG
$adminEmail = "info@vaughnconsulting.co.uk";
$bookingsFile = "bookings.json";

// Ensure bookings file exists
if (!file_exists($bookingsFile)) {
    file_put_contents($bookingsFile, json_encode([]));
}

// Sanitize input
$name  = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$date  = trim($_POST['date'] ?? '');
$time  = trim($_POST['time'] ?? '');

// Validate
if (!$name || !$email || !$date || !$time) {
    echo "All fields are required.";
    exit;
}

// Load bookings
$bookings = json_decode(file_get_contents($bookingsFile), true);

// Prevent double booking
foreach ($bookings as $booking) {
    if ($booking['date'] === $date && $booking['time'] === $time) {
        echo "Sorry, this date and time has already been booked.";
        exit;
    }
}

// Save booking
$bookings[] = [
    "name"  => $name,
    "email" => $email,
    "date"  => $date,
    "time"  => $time
];

file_put_contents($bookingsFile, json_encode($bookings, JSON_PRETTY_PRINT));

/* ======================
   EMAIL TO ADMIN
====================== */

$adminSubject = "New Appointment Booking";
$adminMessage = "
New appointment booking received:

Name: $name
Email: $email
Date: $date
Time: $time
";

$headersAdmin = "From: Website Booking <no-reply@vaughnconsulting.co.uk>\r\n";
$headersAdmin .= "Reply-To: $email\r\n";

mail($adminEmail, $adminSubject, $adminMessage, $headersAdmin);

/* ======================
   EMAIL TO CUSTOMER
====================== */

$userSubject = "Your Appointment Booking Confirmation";
$userMessage = "
Hi $name,

Thank you for booking an appointment with Vaughn Consulting.

Here are your booking details:

Date: $date
Time: $time

If you need to make changes, please reply to this email.

Best regards,
Vaughn Consulting
";

$headersUser = "From: Vaughn Consulting <info@vaughnconsulting.co.uk>\r\n";

mail($email, $userSubject, $userMessage, $headersUser);

// Success response
echo "Appointment booked successfully! A confirmation email has been sent.";
