<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <title>Vaughn Consulting-Appointment Booking</title>
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta content="" name="keywords">
        <meta content="" name="description">

        <!-- Google Web Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet"> 

        <!-- Icon Font Stylesheet -->
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"/>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

        <!-- Libraries Stylesheet -->
        <link href="lib/animate/animate.min.css" rel="stylesheet">
        <link href="lib/lightbox/css/lightbox.min.css" rel="stylesheet">
        <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
        <link rel="icon" type="image/png" href="img/vclogo.png">


        <!-- Customized Bootstrap Stylesheet -->
        <link href="css/bootstrap.min.css" rel="stylesheet">

        <!-- Template Stylesheet -->
        <link href="css/style.css" rel="stylesheet">
    </head>

    <body>

        <!-- Topbar Start -->
        <?php include "includes/topbar.php"  ?>
        <!-- Topbar End -->

        <!-- Navbar & Hero Start -->
        <div class="container-fluid position-relative p-0">
            <nav class="navbar navbar-expand-lg navbar-light px-4 px-lg-5 py-3 py-lg-0">
                <a href="index.php" class="navbar-brand p-0">
                    <img src="img/vclogo.png" alt="Logo">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                    <span class="fa fa-bars"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarCollapse">
                    <div class="navbar-nav ms-auto py-0">
                        <a href="index.php" class="nav-item nav-link">Home</a>
                        <a href="about.php" class="nav-item nav-link">About</a>
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-bs-toggle="dropdown">
                                <span class="dropdown-toggle">Services</span></a>
                            <div class="dropdown-menu m-0">
                                <a href="coaching.php" class="dropdown-item">Coaching</a>
                                <a href="business-support.php" class="dropdown-item">Business Support</a>
                            </div>
                        </div>
                        <a href="contact.php" class="nav-item nav-link active">Contact Us</a>
                    </div>
                    <a href="appointment.php" class="btn btn-primary rounded-pill py-2 px-4 my-3 my-lg-0 flex-shrink-0">Book Appointment</a>
                </div>
            </nav>

            <!-- Header Start -->
            <div class="container-fluid bg-breadcrumb">
                <div class="container text-center py-5" style="max-width: 900px;">
                    <h4 class="text-white display-4 mb-4 wow fadeInDown" data-wow-delay="0.1s">Appointment Booking</h4>
                    <ol class="breadcrumb d-flex justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active text-primary">Appointment</li>
                    </ol>    
                </div>
            </div>
            <!-- Header End -->
        </div>
        <!-- Navbar & Hero End -->

        <!-- Contact Start -->
        <div class="container-fluid contact py-5">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-xl-6">
                        <div class="wow fadeInUp" data-wow-delay="0.2s">
                            <div class="bg-light p-5 rounded h-100">
                                <h4 class="text-primary">Appointment Booking</h4>
                                <h4 class="lh-base mb-4">We are ready to answer you.</h4>
                                <form id="bookingForm" action="book-appointment.php" method="post">
                                    <div class="row g-4">

                                        <!-- Name -->
                                        <div class="col-lg-12 col-xl-6">
                                            <div class="form-floating">
                                                <input type="text" class="form-control border-0" name="name" id="name" placeholder="Your Name" required>
                                                <label for="name">Your Name</label>
                                            </div>
                                        </div>

                                        <!-- Email -->
                                        <div class="col-lg-12 col-xl-6">
                                            <div class="form-floating">
                                                <input type="email" class="form-control border-0" name="email" id="email" placeholder="Your Email" required>
                                                <label for="email">Your Email</label>
                                            </div>
                                        </div>

                                        <!-- Date -->
                                        <div class="col-lg-12 col-xl-6">
                                            <div class="form-floating">
                                                <input type="date" class="form-control border-0" name="date" id="date" required>
                                                <label for="date">Appointment Date</label>
                                            </div>
                                        </div>

                                        <!-- Time -->
                                        <div class="col-lg-12 col-xl-6">
                                            <div class="form-floating">
                                                <select class="form-control border-0" name="time" id="time" required>
                                                    <option value="">Select Time</option>
                                                    <option value="06:00 AM">06:00 AM</option>
                                                    <option value="07:00 AM">07:00 AM</option>
                                                    <option value="08:00 AM">08:00 AM</option>
                                                    <option value="09:00 AM">09:00 AM</option>
                                                    <option value="10:00 AM">10:00 AM</option>
                                                    <option value="11:00 AM">11:00 AM</option>
                                                    <option value="12:00 PM">12:00 PM</option>
                                                    <option value="01:00 PM">01:00 PM</option>
                                                    <option value="02:00 PM">02:00 PM</option>
                                                    <option value="03:00 PM">03:00 PM</option>
                                                    <option value="04:00 PM">04:00 PM</option>
                                                    <option value="05:00 PM">05:00 PM</option>
                                                    <option value="06:00 PM">06:00 PM</option>
                                                </select>
                                                <label for="time">Appointment Time</label>
                                            </div>
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="col-12">
                                            <button class="btn btn-primary w-100 py-3" type="submit">
                                                Book Appointment
                                            </button>
                                        </div>

                                        <!-- Response Message -->
                                        <div class="col-12">
                                            <div id="formResponse"></div>
                                        </div>

                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    
                        <div class="col-xl-6 wow fadeInRight" data-wow-delay="0.2s">
                            <div class="rounded h-100">
                                <img src="img/booking.jpg" 
                                    class="rounded h-100 w-100" 
                                    style="height: 400px; object-fit: cover;" 
                                    alt="Contact Image">
                            </div>
                        </div>
                </div>
            </div>
        </div>
        <!-- Contact End -->

        <!-- Footer Start -->
        <?php include "includes/footer.php"  ?>       

        <script>
document.getElementById("date").addEventListener("change", function () {
    const selectedDate = this.value;
    const timeSelect = document.getElementById("time");

    // Reset options
    Array.from(timeSelect.options).forEach(opt => opt.disabled = false);

    fetch("get-booked-times.php?date=" + selectedDate)
        .then(res => res.json())
        .then(bookedTimes => {
            bookedTimes.forEach(time => {
                const option = timeSelect.querySelector(`option[value="${time}"]`);
                if (option) option.disabled = true;
            });
        });
});
</script>


    </body>

</html>